/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step;

import filenet.vw.api.VWParameter;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.IVWPanelComponent;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWFieldsCellEditor;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import java.text.DateFormat;
import java.util.Date;

public class VWPanelComponentInfo
implements IVWPanelComponent {
    protected String m_parameterName = null;
    protected VWStepElement m_vwStepElement = null;
    protected VWParameter m_vwParameter = null;
    protected Object m_value = null;
    protected boolean m_bIsProtected = true;

    public String getDescription() {
        try {
            if (this.m_vwParameter != null) {
                return this.m_vwParameter.getDescription();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return "";
    }

    public int getType() {
        if (this.m_vwParameter != null) {
            return this.m_vwParameter.getFieldType();
        }
        return -1;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void setValue(Object value) {
        this.m_value = value;
    }

    public boolean isProtected() {
        return this.m_bIsProtected;
    }

    public String getParameterName() {
        if (this.m_parameterName != null) {
            return this.m_parameterName;
        }
        return "";
    }

    public void setParameterName(String name) {
        this.m_parameterName = name;
    }

    public boolean doSave() {
        boolean bSuccess = false;
        boolean bCompare = true;
        int fieldType = 0;
        try {
            if (this.m_value != null && this.m_vwStepElement != null) {
                if (this.m_vwParameter != null && this.m_vwParameter.getMode() != 1) {
                    switch (this.m_vwParameter.getFieldType()) {
                        case 4: {
                            if (!(this.m_value instanceof String)) break;
                            this.m_value = Boolean.valueOf((String)this.m_value);
                            break;
                        }
                        case 8: {
                            if (!(this.m_value instanceof String)) break;
                            this.m_value = new Double((String)this.m_value);
                            break;
                        }
                        case 1: {
                            if (!(this.m_value instanceof String)) break;
                            this.m_value = new Integer((String)this.m_value);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 16: {
                            if (!(this.m_value instanceof String)) break;
                            this.m_value = VWPanelComponentInfo.convertToDate((String)this.m_value);
                        }
                    }
                    fieldType = this.m_vwParameter.getFieldType();
                    bCompare = fieldType != 32 && fieldType != 64 || !this.m_vwParameter.isArray();
                    this.m_vwStepElement.setParameterValue(this.m_vwParameter.getName(), this.m_value, bCompare);
                } else {
                    VWPanelComponentInfo.setParameterValue(this.m_parameterName, this.m_vwStepElement, this.m_value);
                }
                bSuccess = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bSuccess;
    }

    public void setStepElement(VWStepElement stepElement) {
        try {
            if (stepElement == null) {
                return;
            }
            this.m_vwStepElement = stepElement;
            if (this.m_parameterName != null) {
                this.m_value = VWPanelComponentInfo.getParameterValue(this.m_parameterName, stepElement);
                if (this.m_value != null) {
                    String queueName;
                    if (VWStringUtils.compare(this.m_parameterName, "F_Comment") == 0) {
                        this.m_bIsProtected = false;
                    } else if (VWStringUtils.compare(this.m_parameterName, "F_Subject") == 0 && ((queueName = stepElement.getCurrentQueueName()) == null || queueName.length() < 1)) {
                        this.m_bIsProtected = false;
                    }
                } else {
                    this.m_vwParameter = VWPanelComponentInfo.getStepParameter(this.m_parameterName, stepElement);
                    if (this.m_vwParameter != null) {
                        Object tempValue = this.m_vwParameter.getValue();
                        if (tempValue != null) {
                            this.m_value = tempValue instanceof Date ? DateFormat.getDateTimeInstance(2, 2).format((Date)tempValue) : tempValue.toString();
                        }
                        if (this.m_vwParameter.getMode() != 1) {
                            this.m_bIsProtected = false;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private static Date convertToDate(String value) {
        Date date = null;
        if (value != null && value.length() > 0) {
            for (int i = 0; i < VWFieldsCellEditor.s_dateTimeFormatters.length; ++i) {
                try {
                    date = VWFieldsCellEditor.s_dateTimeFormatters[i].parse(value);
                    if (date == null) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return date;
    }

    private static VWParameter getStepParameter(String parameterName, VWStepElement vwStepElement) {
        VWParameter[] params = null;
        try {
            if (parameterName == null || vwStepElement == null) {
                return null;
            }
            params = vwStepElement.getParameters(767, 1);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    if (VWStringUtils.compare(parameterName, params[i].getName()) != 0) continue;
                    return params[i];
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private static String getParameterValue(String parameterName, VWStepElement vwStepElement) {
        String value = null;
        try {
            if (parameterName == null || vwStepElement == null) {
                return null;
            }
            DateFormat dateFormatter = DateFormat.getDateTimeInstance(2, 2);
            if (VWStringUtils.compare(parameterName, "F_Comment") == 0) {
                value = vwStepElement.getComment();
            } else if (VWStringUtils.compare(parameterName, "F_DateReceived") == 0) {
                Date dt = vwStepElement.getDateReceived();
                if (dt != null) {
                    value = dateFormatter.format(dt);
                }
            } else if (VWStringUtils.compare(parameterName, "F_DeadLine") == 0) {
                if (vwStepElement.getOverdue() == 2) {
                    value = VWResource.s_overdue;
                } else if (vwStepElement.getOverdue() == 1) {
                    Date dt = vwStepElement.getDeadline();
                    if (dt != null) {
                        value = VWResource.s_parensReminderSent.toString(dateFormatter.format(dt));
                    }
                } else {
                    Date dt = vwStepElement.getDeadline();
                    if (dt != null) {
                        value = dateFormatter.format(dt);
                    }
                }
            } else if (VWStringUtils.compare(parameterName, "F_ExceptionDescription") == 0) {
                value = vwStepElement.getExceptionDescription();
            } else if (VWStringUtils.compare(parameterName, "F_ExceptionMap") == 0) {
                value = vwStepElement.getExceptionMap();
            } else if (VWStringUtils.compare(parameterName, "F_LaunchDate") == 0) {
                Date dt = vwStepElement.getLaunchDate();
                if (dt != null) {
                    value = dateFormatter.format(dt);
                }
            } else if (VWStringUtils.compare(parameterName, "F_OperationName") == 0) {
                value = vwStepElement.getOperationName();
            } else if (VWStringUtils.compare(parameterName, "F_StepName") == 0) {
                value = vwStepElement.getStepName();
            } else if (VWStringUtils.compare(parameterName, "F_Originator") == 0) {
                VWParticipantItem pItem = new VWParticipantItem(vwStepElement.getOriginatorPx());
                value = pItem.getDisplayName();
            } else if (VWStringUtils.compare(parameterName, "F_Participant") == 0) {
                value = vwStepElement.getParticipantName();
            } else if (VWStringUtils.compare(parameterName, "F_QueueName") == 0) {
                value = vwStepElement.getQueueName();
            } else if (VWStringUtils.compare(parameterName, "F_RosterName") == 0) {
                value = vwStepElement.getRosterName();
            } else if (VWStringUtils.compare(parameterName, "F_SelectedResponse") == 0) {
                value = vwStepElement.getSelectedResponse();
            } else if (VWStringUtils.compare(parameterName, "F_StepDescription") == 0) {
                value = vwStepElement.getStepDescription();
            } else if (VWStringUtils.compare(parameterName, "F_Subject") == 0) {
                value = vwStepElement.getSubject();
            } else if (VWStringUtils.compare(parameterName, "F_Tag") == 0) {
                value = vwStepElement.getTag();
            } else if (VWStringUtils.compare(parameterName, "F_WorkClassName") == 0) {
                value = vwStepElement.getWorkClassName();
            } else if (VWStringUtils.compare(parameterName, "F_WorkflowName") == 0) {
                value = vwStepElement.getWorkflowName();
            } else if (VWStringUtils.compare(parameterName, "F_WorkflowNumber") == 0) {
                value = vwStepElement.getWorkflowNumber();
            } else if (VWStringUtils.compare(parameterName, "F_WorkObjectName") == 0) {
                value = vwStepElement.getWorkObjectName();
            } else if (VWStringUtils.compare(parameterName, "F_WorkObjectNumber") == 0) {
                value = vwStepElement.getWorkObjectNumber();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return value;
    }

    private static void setParameterValue(String parameterName, VWStepElement vwStepElement, Object value) {
        try {
            if (parameterName == null || vwStepElement == null || value == null) {
                return;
            }
            if (VWStringUtils.compare(parameterName, "F_Comment") == 0) {
                vwStepElement.setComment(value.toString());
            } else if (VWStringUtils.compare(parameterName, "F_Subject") == 0 && vwStepElement.hasParameterName("F_Subject")) {
                vwStepElement.setParameterValue("F_Subject", value, true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

